#!/bin/sh

SDK_PROCESSES=("iotmi_mqtt_proxy" "ace_eventmgr" "ace_zigbee_service" "zwave_svc" "iotmi_cdmb" "iotmi_device_agent" "iotmi_lpw_provisioner" "iotmi_log_daemon")

echo "-------Stopping SDK running processes---"
for PROCESS_NAME in "${SDK_PROCESSES[@]}"; do
    killall -9 "$PROCESS_NAME"  # Forcefully kill the process
done

echo "-------Starting Hub SDK-------------"

echo "-------Creating logs directory----------"
LOGS_DIR="$(pwd)/logs"
mkdir -p $LOGS_DIR
if [ -d "$LOGS_DIR" ]; then
  echo "Logs directory created."
else
  echo "Failed to create Logs directory."
fi

echo "-------Verifying Middleware paths-------"
COMMONLIB_DIR="$(pwd)/middleware/AceCommon/"
ZWAVE_DIR="$(pwd)/middleware/AceZwave/"
ZIGBEE_DIR="$(pwd)/middleware/AceZigbee/"
WIFI_DIR="$(pwd)/middleware/AceWifi/"

if [ -d "$COMMONLIB_DIR" ] && [ -d "$ZWAVE_DIR" ] && [ -d "$ZIGBEE_DIR" ] && [ -d "$WIFI_DIR" ]; then
  echo "All middleware libraries exist"
else
    if [ ! -d "$COMMONLIB_DIR" ]; then
        echo "Directory $COMMONLIB_DIR does not exist."
    fi
    if [ ! -d "$ZWAVE_DIR" ]; then
        echo "Directory $ZWAVE_DIR does not exist."
    fi
    if [ ! -d "$ZIGBEE_DIR" ]; then
        echo "Directory $ZIGBEE_DIR does not exist."
    fi
    if [ ! -d "$WIFI_DIR" ]; then
        echo "Directory $WIFI_DIR does not exist."
    fi
    exit 1
fi

export LD_LIBRARY_PATH="$(pwd)/middleware/AceZwave/lib:$(pwd)/middleware/AceCommon/lib:$(pwd)/middleware/AceZigbee/lib:$(pwd)/middleware/AceWifi/lib"
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:"$(pwd)/lib:$(pwd)/usr/lib:$(pwd)/usr/local/lib:$(pwd)/toolchain_lib"
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/lib/aarch64-linux-gnu


echo "-------Verifying Middleware pre reqs---"
AIPC_DIR="/data/aws/greengrass/v2/work/ace/aipc"
KVSTORAGE_DIR="/data/aws/greengrass/v2/work/ace/data/kvstorage"

if [ -d "$AIPC_DIR" ] && [ -d "$KVSTORAGE_DIR" ]; then
  echo "AIPC and KVstroage directories exist"
else
    if [ ! -d "$AIPC_DIR" ]; then
        echo "Directory $AIPC_DIR does not exist."
    fi
    if [ ! -d "$KVSTORAGE_DIR" ]; then
        echo "Directory $KVSTORAGE_DIR does not exist."
    fi
    exit 1
fi

echo "-------Starting HubOnboarding-----------"
./iotmi_hub_onboarding >> $LOGS_DIR/hubOnboarding_logs.txt &
sleep 2

echo "-------Starting MQTT Proxy-----------"
./iotmi_mqtt_proxy -C /data/aws/iotmi/config/iotmi_config.json >> $LOGS_DIR/mqttProxy_logs.txt &
sleep 5

echo "-------Staring Log Daemon---"
./iotmi_log_daemon >> $LOGS_DIR/logDaemon_logs.txt &
sleep 2

echo "-------Starting Event Manager-----------"
./middleware/AceCommon/bin/ace_eventmgr >> $LOGS_DIR/eventManager_logs.txt &
sleep 2

echo "-------Starting Zigbee Service----------"
./middleware/AceZigbee/bin/ace_zigbee_service >> $LOGS_DIR/zigbeeService_logs.txt &
sleep 2

echo "-------Starting Zwave Service----------"
pushd "$(pwd)/middleware/AceZwave/bin/"
./zwave_svc 2>&1 >> $LOGS_DIR/zwaveService_logs.txt &
popd
sleep 5

echo "-------Starting CDMB--------------------"
./iotmi_cdmb >> $LOGS_DIR/cdmb_logs.txt &
sleep 10

echo "-------Starting Agent--------------------"
./iotmi_device_agent >> $LOGS_DIR/agent_logs.txt &
sleep 10

echo "-------Starting Provisioner--------------"
./iotmi_lpw_provisioner >> $LOGS_DIR/provisioner_logs.txt &
sleep 10

echo "-------Checking SDK status---------------"
ERROR_FLAG=0
for PROCESS_NAME in "${SDK_PROCESSES[@]}"; do
  if ps aux | grep -v grep | grep "$PROCESS_NAME"; then
    echo "Process '$PROCESS_NAME' is running."
  else
    echo "Process '$PROCESS_NAME' is not running."
    ERROR_FLAG=1
  fi
done

if [ $ERROR_FLAG -eq 1 ]; then
  echo "------Failed to start Hub SDK---------"
else
  echo "------Successfully Started Hub SDK----"
fi
