// Debug Logger utility for environment-controlled logging
// Uses REACT_APP_DEBUG_LOGGING environment variable

class DebugLogger {
    private debugEnabled: boolean;

    constructor() {
        this.debugEnabled = process.env.REACT_APP_DEBUG_LOGGING === 'true';
    }

    isDebugEnabled(): boolean {
        return this.debugEnabled;
    }

    // Debug log - only logs when REACT_APP_DEBUG_LOGGING=true
    log(...args: any[]) {
        if (this.debugEnabled) {
            console.log(...args);
        }
    }

    // Debug warn - only logs when REACT_APP_DEBUG_LOGGING=true
    warn(...args: any[]) {
        if (this.debugEnabled) {
            console.warn(...args);
        }
    }

    // Debug error - only logs when REACT_APP_DEBUG_LOGGING=true
    error(...args: any[]) {
        if (this.debugEnabled) {
            console.error(...args);
        }
    }

    // Always log (for important messages that should always appear)
    always(...args: any[]) {
        console.log(...args);
    }

    // Always warn (for important warnings that should always appear)
    alwaysWarn(...args: any[]) {
        console.warn(...args);
    }

    // Always error (for important errors that should always appear)
    alwaysError(...args: any[]) {
        console.error(...args);
    }
}

// Global instance
export const debugLogger = new DebugLogger();

// Make it available globally for debugging
(window as any).debugLogger = debugLogger;

export default debugLogger;
