import { Capability } from './deviceTypes';
import { FC } from 'react';

export interface ClusterProps {
    capability: Capability;
    deviceId: string;
}

export interface ClusterComponent {
    // Render the full capability details view
    renderDetails: (props: ClusterProps) => React.ReactElement;
    // Render a compact widget view for the capability
    renderWidget: (props: ClusterProps) => React.ReactElement;
}

// Helper type for cluster implementations
export type ClusterImplementation = FC<ClusterProps> & ClusterComponent; 