// src/types/authTypes.ts
export type AuthenticationMethod = 'inclusion' | 'manual';

export interface AuthenticationState {
    method: AuthenticationMethod | null;
    inclusionModeEnabled: boolean;
}


export enum AuthMethod {
    ZWAVE_PIN = 'ZWAVE_PIN',
    ZWAVE_DSK = 'ZWAVE_DSK',
    ZWAVE_INCLUSION = 'ZWAVE_INCLUSION',
    ZIGBEE_INCLUSION = 'ZIGBEE_INCLUSION',
    ZIGBEE_INSTALL_CODE = 'ZIGBEE_INSTALL_CODE'
}

export interface AuthenticationMaterial {
    type: string;
    value: string;
}

export interface AuthDetails {
    pinCode?: string;
    dsk?: string;
    installCode?: string;
    mode?: 'SECURE' | 'UNSECURE';
}
