// src/store/store.ts
import { configureStore } from '@reduxjs/toolkit';
import { persistStore, persistReducer } from 'redux-persist';
import storage from 'redux-persist/lib/storage';
import deviceReducer from './deviceSlice';
import hubReducer from './hubSlice';
import subscriptionReducer, { subscriptionMiddleware } from './subscriptionSlice';

// Persist configs
const devicePersistConfig = {
    key: 'devices',
    storage,
};

const hubPersistConfig = {
    key: 'hub',
    storage,
};

// Create persisted reducers
const persistedDeviceReducer = persistReducer(devicePersistConfig, deviceReducer);
const persistedHubReducer = persistReducer(hubPersistConfig, hubReducer);

// Configure store
export const store = configureStore({
    reducer: {
        devices: persistedDeviceReducer,
        hub: persistedHubReducer,
        subscriptions: subscriptionReducer
    },
    middleware: (getDefaultMiddleware) =>
        getDefaultMiddleware({
            serializableCheck: {
                ignoredActions: ['persist/PERSIST', 'persist/REHYDRATE'],
            },
        }).concat(subscriptionMiddleware),
});

export const persistor = persistStore(store);

// Types
export type RootState = ReturnType<typeof store.getState>;
export type AppDispatch = typeof store.dispatch;
