// src/store/slices/authSlice.ts
import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { AuthenticationState, AuthenticationMethod } from '../types/authTypes';

const initialState: AuthenticationState = {
    method: null,
    inclusionModeEnabled: false
};

const authSlice = createSlice({
    name: 'auth',
    initialState,
    reducers: {
        setAuthMethod(state, action: PayloadAction<AuthenticationMethod>) {
            state.method = action.payload;
        },
        setInclusionMode(state, action: PayloadAction<boolean>) {
            state.inclusionModeEnabled = action.payload;
        }
    }
});

export const { setAuthMethod, setInclusionMode } = authSlice.actions;
export default authSlice.reducer;
