import { deviceService } from './deviceService';
import { deviceStatePollingService } from './deviceStatePollingService';

export async function initializeServices() {
    try {
        console.log('Initializing services...');
        
        // Initialize the DeviceStatePollingService
        await deviceStatePollingService.initialize();
        console.log('DeviceStatePollingService initialized and ready');
        
        // Return success - devices will be loaded and polling started by dashboard/device-detail pages
        return true;
    } catch (error) {
        console.error('Error initializing services:', error);
        throw error;
    }
}