import { useState, useEffect } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { RootState } from '../store/store';
import { deviceMonitorService } from '../services/deviceMonitorService';
import { Device } from '../types/deviceTypes';

interface UseDeviceMonitoringReturn {
    showNamingDialog: boolean;
    pendingDevice: Device | null;
    handleNameSubmit: (name: string) => void;
    handleCancelNaming: () => void;
}

export const useDeviceMonitoring = (): UseDeviceMonitoringReturn => {
    const dispatch = useDispatch();
    const [showNamingDialog, setShowNamingDialog] = useState(false);
    const [pendingDevice, setPendingDevice] = useState<Device | null>(null);
    const devices = useSelector((state: RootState) => state.devices.devices);

    useEffect(() => {
        // Don't automatically start monitoring - let pages control it
        console.log('useDeviceMonitoring hook initialized - monitoring controlled by pages');

        // Cleanup on unmount
        return () => {
            console.log('useDeviceMonitoring hook cleanup - stopping monitoring');
            deviceMonitorService.stopMonitoring();
        };
    }, []);

    const handleNameSubmit = (name: string) => {
        if (pendingDevice) {
            // Update device name in store
            dispatch({
                type: 'devices/updateDeviceName',
                payload: {
                    ManagedThingId: pendingDevice.ManagedThingId,
                    name
                }
            });
            setShowNamingDialog(false);
            setPendingDevice(null);
        }
    };

    const handleCancelNaming = () => {
        setShowNamingDialog(false);
        setPendingDevice(null);
    };

    return {
        showNamingDialog,
        pendingDevice,
        handleNameSubmit,
        handleCancelNaming
    };
};