// Application constants
export const APP_CONFIG = {
  NAME: 'IoT Managed Integrations App',
  VERSION: '0.1.0',
  DEFAULT_POLLING_INTERVAL: 5000, // 5 seconds
  MAX_RETRY_ATTEMPTS: 3,
} as const;

// Hub configuration - reads from environment variable with fallback
export const HUB_CONFIG = {
  MANAGED_THING_ID: process.env.REACT_APP_HUB_MANAGED_THING_ID || '7c773ecab1c4456e84bd1c39b9a3d819',
  CREDENTIAL_LOCKER_ID: process.env.REACT_APP_CREDENTIAL_LOCKER_ID || 'd1a468c1a9ff47719bc3f0a17d109c1b',
} as const;

// Route paths
export const ROUTES = {
  HOME: '/',
  DASHBOARD: '/',
  ONBOARD: '/onboard',
  SIMPLE_ONBOARD: '/simple-onboard',
  DEVICE_DETAIL: '/device/:id',
  ENV_TEST: '/env-test',
} as const;

// Device types
export const DEVICE_TYPES = {
  BULB: 'bulb',
  SWITCH: 'switch',
  SENSOR: 'sensor',
  THERMOSTAT: 'thermostat',
} as const;

// Device states
export const DEVICE_STATES = {
  ONLINE: 'online',
  OFFLINE: 'offline',
  UNKNOWN: 'unknown',
} as const;

// Error messages
export const ERROR_MESSAGES = {
  INITIALIZATION_FAILED: 'Failed to initialize application',
  DEVICE_LOAD_FAILED: 'Failed to load devices',
  SERVICE_UNAVAILABLE: 'Service temporarily unavailable',
  NETWORK_ERROR: 'Network connection error',
  UNKNOWN_ERROR: 'An unknown error occurred',
} as const;

// Success messages
export const SUCCESS_MESSAGES = {
  DEVICE_ADDED: 'Device added successfully',
  DEVICE_UPDATED: 'Device updated successfully',
  DEVICE_REMOVED: 'Device removed successfully',
} as const;

// Loading messages
export const LOADING_MESSAGES = {
  INITIALIZING: 'Initializing services...',
  LOADING_DEVICES: 'Loading devices...',
  CONNECTING: 'Connecting to device...',
  SAVING: 'Saving changes...',
} as const;
