// src/components/onboarding/steps/ProtocolSelection.tsx

import React, { useState, useEffect } from 'react';
import {
    Box,
    Typography,
    RadioGroup,
    FormControlLabel,
    Radio,
    Paper
} from '@mui/material';
import { ProtocolType } from '../../../types/deviceTypes';

interface ProtocolSelectionProps {
    selectedProtocol?: ProtocolType;
    onSelect: (protocol: ProtocolType) => void;
}

export const ProtocolSelection: React.FC<ProtocolSelectionProps> = ({
                                                                        selectedProtocol,
                                                                        onSelect
                                                                    }) => {
    // Initialize with a default value to ensure it's always controlled
    const [protocol, setProtocol] = useState<ProtocolType>(
        selectedProtocol || ProtocolType.ZWAVE
    );
    
    // Update internal state when prop changes
    useEffect(() => {
        if (selectedProtocol) {
            setProtocol(selectedProtocol);
        }
    }, [selectedProtocol]);

    const handleChange = (e: React.ChangeEvent<HTMLInputElement>) => {
        const value = e.target.value as ProtocolType;
        setProtocol(value);
        onSelect(value);
    };

    return (
        <Box>
            <Typography variant="h6" gutterBottom>
                Select Protocol
            </Typography>
            <Paper sx={{ p: 3 }}>
                <RadioGroup
                    value={protocol}
                    onChange={handleChange}
                >
                    <FormControlLabel
                        value={ProtocolType.ZWAVE}
                        control={<Radio />}
                        label="Z-Wave"
                    />
                    <FormControlLabel
                        value={ProtocolType.ZIGBEE}
                        control={<Radio />}
                        label="Zigbee"
                    />
                </RadioGroup>
            </Paper>
        </Box>
    );
};
