// src/components/onboarding/steps/OnboardingComplete.tsx

import React from 'react';
import {
    Box,
    Typography,
    Paper
} from '@mui/material';
import { CheckCircle } from '@mui/icons-material';

interface OnboardingCompleteProps {
    onboardingData: any;
}

export const OnboardingComplete: React.FC<OnboardingCompleteProps> = ({
                                                                          onboardingData
                                                                      }) => {
    return (
        <Box sx={{ textAlign: 'center' }}>
            <CheckCircle
                color="success"
                sx={{ fontSize: 64, mb: 2 }}
            />
            <Typography variant="h5" gutterBottom>
                Device Authentication Complete
            </Typography>
            <Paper sx={{ p: 3, mt: 3, textAlign: 'left' }}>
                <Typography variant="subtitle1" gutterBottom>
                    Authentication Details:
                </Typography>
                <Typography variant="body2">
                    Protocol: {onboardingData.protocol}
                </Typography>
                <Typography variant="body2">
                    Authentication Method: {onboardingData.authMethod}
                </Typography>
                <Typography variant="body2">
                    Inclusion Mode: {onboardingData.authDetails?.inclusionMode}
                </Typography>
            </Paper>
        </Box>
    );
};
