// src/components/onboarding/steps/AuthMethodSelection.tsx

import React from 'react';
import {
    Box,
    Typography,
    RadioGroup,
    FormControlLabel,
    Radio,
    Paper
} from '@mui/material';
import { ProtocolType } from '../../../types/deviceTypes';
import { AuthMethod } from '../../../types/authTypes';

interface AuthMethodSelectionProps {
    protocol: ProtocolType;
    selectedMethod?: AuthMethod;
    onSelect: (method: AuthMethod) => void;
}

export const AuthMethodSelection: React.FC<AuthMethodSelectionProps> = ({
    protocol,
    selectedMethod,
    onSelect
}) => {
    const getAuthMethods = () => {
        switch (protocol) {
            case ProtocolType.ZWAVE:
                return [
                    { value: AuthMethod.ZWAVE_PIN, label: 'PIN Code' },
                    { value: AuthMethod.ZWAVE_DSK, label: 'DSK' },
                    { value: AuthMethod.ZWAVE_INCLUSION, label: 'Inclusion Mode' }
                ];
            case ProtocolType.ZIGBEE:
                return [
                    { value: AuthMethod.ZIGBEE_INSTALL_CODE, label: 'Install Code' },
                    { value: AuthMethod.ZIGBEE_INCLUSION, label: 'Inclusion Mode' }
                ];
            default:
                return [];
        }
    };

    const authMethods = getAuthMethods();
    const defaultMethod = authMethods[0]?.value;

    return (
        <Box>
            <Typography variant="h6" gutterBottom>
                Select Authentication Method
            </Typography>
            <Paper sx={{ p: 3 }}>
                <RadioGroup
                    value={selectedMethod || defaultMethod}
                    onChange={(e) => onSelect(e.target.value as AuthMethod)}
                >
                    {authMethods.map((method) => (
                        <FormControlLabel
                            key={method.value}
                            value={method.value}
                            control={<Radio />}
                            label={method.label}
                        />
                    ))}
                </RadioGroup>
            </Paper>
        </Box>
    );
};
