import React from 'react';
import {
    Box,
    Typography,
    List,
    ListItem,
    ListItemText,
    Divider
} from '@mui/material';
import { Device } from '../../types/deviceTypes';

interface DeviceStatsProps {
    devices?: Device[];
}

export const DeviceStats: React.FC<DeviceStatsProps> = ({ devices = [] }) => {
    const totalDevices = devices.length;
    const zwaveDevices = devices.filter(d => d.Protocol === 'ZWAVE').length;
    const zigbeeDevices = devices.filter(d => d.Protocol === 'ZIGBEE').length;

    return (
        <>
            <Typography variant="h6" gutterBottom>
                Device Statistics
            </Typography>
            <List>
                <ListItem>
                    <ListItemText
                        primary="Total Devices"
                        secondary={totalDevices}
                    />
                </ListItem>
                <Divider />
                <ListItem>
                    <ListItemText
                        primary="Z-Wave Devices"
                        secondary={zwaveDevices}
                    />
                </ListItem>
                <Divider />
                <ListItem>
                    <ListItemText
                        primary="Zigbee Devices"
                        secondary={zigbeeDevices}
                    />
                </ListItem>
            </List>
        </>
    );
}; 