import React from 'react';
import { useSelector } from 'react-redux';
import { Box, Typography } from '@mui/material';
import { RootState } from '../../store/store';
import DeviceWidget from '../devices/DeviceWidget';

export const Dashboard: React.FC = () => {
    const devices = useSelector((state: RootState) => state.devices.devices);

    return (
        <Box sx={{ p: 3 }}>
            <Typography variant="h4" gutterBottom>
                Smart Home Dashboard
            </Typography>
            <Box sx={{ 
                display: 'flex', 
                flexWrap: 'wrap', 
                gap: 3,
                '& > *': {
                    flex: { xs: '1 1 100%', sm: '1 1 calc(50% - 24px)', md: '1 1 calc(33.333% - 24px)' }
                }
            }}>
                {devices.map((device) => (
                    <Box key={device.ManagedThingId}>
                        <DeviceWidget device={device} />
                    </Box>
                ))}
            </Box>
        </Box>
    );
}; 