import React from 'react';
import { Dialog, DialogTitle, DialogContent, DialogActions, TextField, Button } from '@mui/material';

interface NamingDialogProps {
    open: boolean;
    onClose: () => void;
    onSubmit: (name: string) => void;
    deviceName: string;
    onNameChange: (name: string) => void;
}

export const NamingDialog: React.FC<NamingDialogProps> = ({
    open,
    onClose,
    onSubmit,
    deviceName,
    onNameChange
}) => {
    return (
        <Dialog open={open} onClose={onClose}>
            <DialogTitle>Name New Device</DialogTitle>
            <DialogContent>
                <TextField
                    autoFocus
                    margin="dense"
                    label="Device Name"
                    fullWidth
                    value={deviceName}
                    onChange={(e) => onNameChange(e.target.value)}
                />
            </DialogContent>
            <DialogActions>
                <Button onClick={onClose}>Cancel</Button>
                <Button onClick={() => onSubmit(deviceName)} variant="contained" color="primary">
                    Add Device
                </Button>
            </DialogActions>
        </Dialog>
    );
}; 