import React, { useState } from 'react';
import {
    Dialog,
    DialogTitle,
    DialogContent,
    DialogContentText,
    DialogActions,
    Button,
    TextField
} from '@mui/material';
import { useDeviceMonitoring } from '../hooks/useDeviceMonitoring';

export const GlobalNamingDialog: React.FC = () => {
    const [newDeviceName, setNewDeviceName] = useState('');
    const { showNamingDialog, pendingDevice, handleNameSubmit, handleCancelNaming } = useDeviceMonitoring();

    const handleSubmit = () => {
        if (newDeviceName.trim()) {
            handleNameSubmit(newDeviceName.trim());
            setNewDeviceName('');
        }
    };

    const handleClose = () => {
        handleCancelNaming();
        setNewDeviceName('');
    };

    return (
        <Dialog 
            open={showNamingDialog} 
            onClose={handleClose}
            aria-labelledby="name-dialog-title"
        >
            <DialogTitle id="name-dialog-title">Name Your Device</DialogTitle>
            <DialogContent>
                <DialogContentText>
                    Please enter a name for your device to make it easier to identify.
                </DialogContentText>
                <TextField
                    autoFocus
                    margin="dense"
                    id="name"
                    label="Device Name"
                    type="text"
                    fullWidth
                    variant="outlined"
                    value={newDeviceName}
                    onChange={(e) => setNewDeviceName(e.target.value)}
                    onKeyPress={(e) => e.key === 'Enter' && handleSubmit()}
                    sx={{ mt: 2 }}
                />
            </DialogContent>
            <DialogActions>
                <Button onClick={handleClose}>Cancel</Button>
                <Button 
                    onClick={handleSubmit}
                    variant="contained"
                    disabled={!newDeviceName.trim()}
                >
                    Save
                </Button>
            </DialogActions>
        </Dialog>
    );
}; 