import React from 'react';
import { useSelector } from 'react-redux';
import { Box, Typography, Alert, Card, CardContent } from '@mui/material';
import { RootState } from '../store/store';

export const DeviceList: React.FC = () => {
    const devices = useSelector((state: RootState) => state.devices.devices);
    const isLoading = useSelector((state: RootState) => state.devices.loading);

    if (isLoading) {
        return (
            <Box>
                <Typography variant="h6" gutterBottom>
                    Loading devices...
                </Typography>
            </Box>
        );
    }

    if (devices.length === 0) {
        return (
            <Box>
                <Typography variant="h6" gutterBottom>
                    Connected Devices (0)
                </Typography>
                <Alert severity="info" sx={{ mb: 2 }}>
                    No devices found. Try adding a device through the onboarding process.
                </Alert>
            </Box>
        );
    }

    return (
        <Box>
            <Typography variant="h6" gutterBottom>
                Connected Devices ({devices.length})
            </Typography>
            <Box sx={{ display: 'flex', flexDirection: 'column', gap: 2 }}>
                {devices.map((device) => (
                    <Card key={device.ManagedThingId} variant="outlined">
                        <CardContent>
                            <Typography variant="h6" component="h3">
                                {device.Name || 'Unnamed Device'}
                            </Typography>
                            <Typography variant="body2" color="text.secondary">
                                ID: {device.ManagedThingId}
                            </Typography>
                        </CardContent>
                    </Card>
                ))}
            </Box>
        </Box>
    );
}; 