import React from 'react';
import { Card, CardContent, Typography, CardActions, Button, Box } from '@mui/material';
import { Device } from '../types/deviceTypes';

interface DeviceCardProps {
    device: Device;
}

export const DeviceCard: React.FC<DeviceCardProps> = ({ device }) => {
    return (
        <Card>
            <CardContent>
                <Typography variant="h6" component="div">
                    {device.Name || 'Unnamed Device'}
                </Typography>
                <Typography color="text.secondary" gutterBottom>
                    ID: {device.ManagedThingId}
                </Typography>
                <Typography variant="body2">
                    Protocol: {device.Protocol}
                </Typography>
                <Box mt={2}>
                    <Typography variant="subtitle2">Capabilities:</Typography>
                    {device.CapabilityReport?.endpoints.map((endpoint, index) => (
                        endpoint.capabilities.map((capability, capIndex) => (
                            <Typography key={`${index}-${capIndex}`} variant="body2">
                                • {capability.name}
                            </Typography>
                        ))
                    ))}
                </Box>
            </CardContent>
            <CardActions>
                <Button size="small" color="primary">
                    View Details
                </Button>
                <Button size="small" color="primary">
                    Control
                </Button>
            </CardActions>
        </Card>
    );
}; 