import { Capability } from '../types/deviceTypes';
import OnOffCluster from './OnOffCluster';
import LevelControlCluster from './LevelControlCluster';
import ColorControlCluster from './ColorControlCluster';
import TemperatureMeasurementCluster from './TemperatureMeasurementCluster';
import BooleanStateCluster from './BooleanStateCluster';

// Define props interface for consistency across clusters
export interface ClusterProps {
  capability: Capability;
  deviceId: string;
}

// Get the appropriate cluster component for a given capability
export const getClusterComponent = (capability: Capability): any => {
    const id = capability.id.toLowerCase();
    const name = capability.name.toLowerCase();
    
    if (id.includes('onoff')) {
        return OnOffCluster;
    } else if (id.includes('levelcontrol')) {
        return LevelControlCluster;
    } else if (id.includes('colorcontrol')) {
        return ColorControlCluster;
    } else if (id.includes('temperaturemeasurement') || name.includes('temperature measurement')) {
        return TemperatureMeasurementCluster;
    } else if (id.includes('booleanstate') || name.includes('boolean state')) {
        return BooleanStateCluster;
    }
    
    return null;
};