import React from 'react';
import { Box, Typography } from '@mui/material';
import { ClusterImplementation, ClusterProps } from '../types/clusterTypes';

// Details view component
const DimmingDetails: React.FC<ClusterProps> = ({ capability }) => {
    return (
        <Box>
            <Typography variant="subtitle2">
                {capability.name} (Not implemented)
            </Typography>
            <Typography variant="body2" color="text.secondary">
                Dimming control is not yet implemented
            </Typography>
        </Box>
    );
};

// Widget view component
const DimmingWidget: React.FC<ClusterProps> = ({ capability }) => {
    return (
        <Box sx={{ 
            display: 'flex', 
            alignItems: 'center', 
            gap: 1,
            p: 1,
            borderRadius: 1,
            bgcolor: 'background.paper',
            boxShadow: 1
        }}>
            <Typography variant="body2" color="text.secondary">
                Dimming (Not implemented)
            </Typography>
        </Box>
    );
};

// Main cluster component
export const DimmingCluster: ClusterImplementation = ({ capability, deviceId }) => {
    // Default render function for the component
    return <DimmingDetails capability={capability} deviceId={deviceId} />;
};

// Implementation of the ClusterComponent interface
DimmingCluster.renderDetails = ({ capability, deviceId }: ClusterProps) => {
    return <DimmingDetails capability={capability} deviceId={deviceId} />;
};

DimmingCluster.renderWidget = ({ capability, deviceId }: ClusterProps) => {
    return <DimmingWidget capability={capability} deviceId={deviceId} />;
}; 